/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view.jProp;

import adecWatt.model.InseeDB;
import adecWatt.view.JEditable;
import adecWatt.view.jProp.JAutoComboBox;
import adecWatt.view.jProp.JPLabel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import misc.Util;

public class JPropCity
extends JPLabel
implements JAutoComboBox.Filter {
    public static final int maxPropal = 500;
    protected JComponent[] jComponents = new JComponent[2];
    protected JAutoComboBox jCity;
    protected ArrayList<InseeDB.Insee> filteredCity;

    protected void plotCity() {
        if (this.filteredCity == null) {
            return;
        }
        int nbInsee = this.filteredCity.size();
        int idx = this.jCity.getSelectedIndex();
        if (nbInsee == 1) {
            idx = 0;
        }
        if (idx < 0) {
            return;
        }
        InseeDB.Insee insee = this.filteredCity.get(idx);
        this.jEditable.plotCity(insee.latitude, insee.longitude);
    }

    @Override
    public Vector<String> match(String value) {
        try {
            this.filteredCity = this.adecWatt.getInseeDB().getCities(value);
        }
        catch (Exception e) {
            this.filteredCity = null;
        }
        if (this.filteredCity == null) {
            return null;
        }
        if (this.filteredCity.size() > 500) {
            this.filteredCity = null;
            return null;
        }
        Vector<String> filteredCityName = new Vector<String>(this.filteredCity.size());
        for (InseeDB.Insee insee : this.filteredCity) {
            filteredCityName.add(insee.name);
        }
        return filteredCityName;
    }

    public JPropCity(String propName, JEditable jEditable) {
        super(propName, jEditable);
    }

    @Override
    protected JComponent getEditor() {
        this.jCity = new JAutoComboBox(this);
        JTextComponent editor = this.jCity.getEditorComponent();
        this.editors = new JTextComponent[]{editor};
        this.setChangeListener(editor);
        editor.setText(this.lastValue);
        this.jCity.updateFilter();
        JPanel jPanel = new JPanel();
        jPanel.add(this.jCity);
        jPanel.add(Util.newIconButton("PlotCity", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPropCity.this.plotCity();
            }
        }));
        Util.unBoxButton(jPanel);
        return jPanel;
    }
}

