/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Component;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListModel;
import misc.Util;

public class Config {
    public static final String FS = System.getProperty("file.separator");
    public static final String dataDirname = "data";
    public static final String configDirname = "config";
    public static final String textsDirname = "texts";
    public static final String logDirname = "log";
    public static final String imagesDirname = "images";
    public static final String iconsDirname = "images";
    public static final String buttonDirname = "button";
    public static final String flagsDirname = "flags";
    public static final String configSystemDir = "data" + FS + "config" + FS;
    public static final String logSystemDir = "data" + FS + "log" + FS;
    public static final String buttonSystemDir = "data" + FS + "images" + FS + "button" + FS;
    public static final String configJarDir = "data/config/";
    public static final String imagesJarDir = "data/images/";
    public static final String textsJarDir = "data/texts/";
    public static final String configExt = ".xml";
    public static final String iconsExt = ".png";
    public static final String imagesExt = ".png";
    public static final String htmlExt = ".html";
    public static final String logExt = ".log";
    public static final String configEncoding = "UTF8";
    public static final String configHeaderFile = "This file is automaticaly generated by {0} application at {1,time,short} on {1,date}.";
    public static final String checkedPostfix = "Checked";
    public static final String undockedPostfix = "Undocked";
    public static final String locationPostfix = "Location";
    private static final String configNullKeyException = "No configuration associates with null key.";
    private static final String configUseException = "No configuration loaded.";
    private static final String configLoadException = "Configuration {0} can''t be load (corrupted file ?).";
    private static final String configSaveException = "Configuration {0} can''t be save.";
    public static Properties configuration;
    private static boolean configurationModified;
    private static File PWD;
    private static String[] dataPath;
    public static final DecimalFormat indexFormat;
    public static final MessageFormat coordonateFormat;

    public static File getJarFileOrClassDir(Class<?> applicationClass) {
        try {
            return new File(applicationClass.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static File getPWD() {
        return PWD;
    }

    public static void setPWD(Class<?> applicationClass) {
        try {
            PWD = Config.getJarFileOrClassDir(applicationClass).getParentFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setDataPath(String path) {
        dataPath = path.split(":");
    }

    public static File findDataDir() {
        return Config.findDataDir(false);
    }

    public static File findDataDir(boolean writable) {
        String name = dataDirname;
        try {
            File file = new File(name);
            if (file.exists() && file.isDirectory() && (!writable || file.canWrite())) {
                return file;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String path : dataPath) {
            try {
                File file = new File(PWD, path + FS + name);
                if (!file.exists() || !file.isDirectory() || writable && !file.canWrite()) continue;
                return file;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static URL getDataUrl(String ... names) {
        if (names.length < 1) {
            return null;
        }
        String name = names[names.length - 1];
        String jarPath = "";
        String systemPath = "";
        for (int i = 0; i < names.length - 1; ++i) {
            jarPath = jarPath + names[i] + "/";
            systemPath = systemPath + names[i] + FS;
        }
        try {
            File file = new File(systemPath + name);
            if (file.exists()) {
                return file.toURI().toURL();
            }
        }
        catch (Exception file) {
            // empty catch block
        }
        for (String path : dataPath) {
            try {
                File file = new File(PWD, (String)path + FS + systemPath + name);
                if (!file.exists()) continue;
                return file.getCanonicalFile().toURI().toURL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            URL result = ClassLoader.getSystemResource(jarPath + name);
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final void load(String applicationName) {
        block6: {
            configuration = new Properties();
            try {
                File configDir = new File(Config.findDataDir(), configDirname);
                File configFile = new File(configDir, applicationName + configExt);
                FileInputStream fileInputStream = new FileInputStream(configFile);
                configuration.loadFromXML(fileInputStream);
                fileInputStream.close();
                configurationModified = false;
            }
            catch (Exception e) {
                try {
                    configuration.loadFromXML(ClassLoader.getSystemResourceAsStream(configJarDir + applicationName + configExt));
                    configurationModified = false;
                }
                catch (Exception e2) {
                    try {
                        configuration.loadFromXML(ClassLoader.getSystemResourceAsStream(configJarDir + applicationName + configExt));
                        configurationModified = false;
                    }
                    catch (Exception e3) {
                        if (0 == JOptionPane.showConfirmDialog(null, "Would you like to continue?", " Can't load Configuration ", 0)) break block6;
                        throw new IllegalArgumentException(MessageFormat.format(configLoadException, applicationName));
                    }
                }
            }
        }
    }

    public static boolean isLoaded() {
        return configuration != null;
    }

    public static final void save(String applicationName) {
        File configDir = new File(Config.findDataDir(true), configDirname);
        File configFile = new File(configDir, applicationName + configExt);
        try {
            Config.save(applicationName, configFile);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                configDir.mkdirs();
                Config.save(applicationName, configFile);
            }
            catch (IOException e2) {
                System.err.println(MessageFormat.format(configSaveException, applicationName));
            }
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException(configUseException);
        }
    }

    public static final void save(String applicationName, File file) throws IOException {
        if (!configurationModified && file.exists()) {
            return;
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        configuration.storeToXML((OutputStream)fileOutputStream, new MessageFormat(configHeaderFile, Locale.US).format(new Object[]{applicationName, new Date()}, new StringBuffer(), (FieldPosition)null).toString(), configEncoding);
        fileOutputStream.close();
        configurationModified = false;
    }

    public static final String getString(String key) {
        if (key == null) {
            throw new IllegalArgumentException(configNullKeyException);
        }
        try {
            return configuration.getProperty(key);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException(configUseException);
        }
    }

    public static final String getString(String key, String defaultValue) {
        String value = configuration.getProperty(key);
        if (value != null) {
            return value;
        }
        configuration.setProperty(key, defaultValue);
        return defaultValue;
    }

    public static final void setString(String key, String value) {
        try {
            configuration.setProperty(key, value);
            configurationModified = true;
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException(configUseException);
        }
    }

    public static final File getFile(String key) {
        String fileName = Config.getString(key);
        if (fileName == null) {
            return null;
        }
        return new File(fileName);
    }

    public static final void setFile(String key, File file) {
        Config.setString(key, file.getPath());
    }

    public static final boolean getBoolean(String key) {
        return Boolean.parseBoolean(Config.getString(key));
    }

    public static final boolean getBoolean(String key, boolean defaultValue) {
        return Boolean.parseBoolean(Config.getString(key, "" + defaultValue));
    }

    public static final void setBoolean(String key, boolean value) {
        Config.setString(key, "" + value);
    }

    public static final int getInt(String key) {
        return Integer.parseInt(Config.getString(key));
    }

    public static final int getInt(String key, int defaultValue) {
        try {
            return Integer.parseInt(Config.getString(key, "" + defaultValue));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static final void setInt(String key, int value) {
        Config.setString(key, "" + value);
    }

    public static final float getFloat(String key) {
        return Float.parseFloat(Config.getString(key));
    }

    public static final float getFloat(String key, float defaultValue) {
        try {
            return Float.parseFloat(Config.getString(key, "" + defaultValue));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static final void setFloat(String key, float value) {
        Config.setString(key, "" + value);
    }

    public static final double getDouble(String key) {
        return Double.parseDouble(Config.getString(key));
    }

    public static final double getDouble(String key, double defaultValue) {
        try {
            return Double.parseDouble(Config.getString(key, "" + defaultValue));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static final void setDouble(String key, double value) {
        Config.setString(key, "" + value);
    }

    public static final <T> T getEnum(String key, T defaultValue) {
        return Util.toEnum(Config.getString(key, "" + defaultValue), defaultValue);
    }

    public static final Vector<String> getList(String key, String defaultValue) {
        Vector<String> result = new Vector<String>();
        int size = Integer.parseInt(Config.getString(key + "-size", "1"));
        result.add(Config.getString(key, defaultValue));
        for (int i = 1; i < size; ++i) {
            result.add(Config.getString(key + indexFormat.format(i)));
        }
        return result;
    }

    public static final void setList(String key, Vector<String> value) {
        int size = value.size();
        int max = Integer.parseInt(Config.getString(key + "-max", "10"));
        Config.setString(key + "-max", "" + max);
        Config.setString(key + "-size", "" + size);
        Config.setString(key, value.elementAt(0));
        size = Math.min(size, max);
        for (int i = 1; i < size; ++i) {
            Config.setString(key + indexFormat.format(i), value.elementAt(i));
        }
    }

    public static final void loadJList(String key, JList<String> jList, String defaultValue) {
        Vector<String> list = Config.getList(key, defaultValue);
        jList.setListData(list);
        jList.setSelectedIndex(0);
    }

    public static final void saveJList(String key, JList<String> jList) {
        Vector<String> result = new Vector<String>();
        ListModel<String> model = jList.getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            result.add(model.getElementAt(i));
        }
        int index = jList.getSelectedIndex();
        if (index >= 0) {
            result.insertElementAt(result.remove(index), 0);
            jList.setListData(result);
            jList.setSelectedIndex(0);
        }
        Config.setList(key, result);
    }

    public static final void loadJComboBox(String key, JComboBox<String> jComboBox, String defaultValue) {
        Vector<String> list = Config.getList(key, defaultValue);
        jComboBox.removeAllItems();
        for (int i = 0; i < list.size(); ++i) {
            jComboBox.addItem(list.elementAt(i));
        }
        jComboBox.setSelectedIndex(0);
    }

    public static final void loadJComboBoxInteger(String key, JComboBox<Integer> jComboBox, String defaultValue) {
        Vector<String> list = Config.getList(key, defaultValue);
        jComboBox.removeAllItems();
        for (int i = 0; i < list.size(); ++i) {
            try {
                jComboBox.addItem(Integer.parseInt(list.elementAt(i)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        jComboBox.setSelectedIndex(0);
    }

    public static final void saveJComboBox(String key, JComboBox<String> jComboBox) {
        Vector<String> result = new Vector<String>();
        int size = jComboBox.getItemCount();
        for (int i = 0; i < size; ++i) {
            result.add(jComboBox.getItemAt(i));
        }
        int index = jComboBox.getSelectedIndex();
        if (index < 0) {
            result.insertElementAt((String)jComboBox.getSelectedItem(), 0);
        } else {
            result.insertElementAt((String)result.remove(index), 0);
        }
        if (index != 0) {
            jComboBox.removeAllItems();
            for (int i = 0; i < result.size(); ++i) {
                jComboBox.addItem(result.elementAt(i));
            }
            jComboBox.setSelectedIndex(0);
        }
        Config.setList(key, result);
    }

    public static final void saveJComboBoxInteger(String key, JComboBox<Integer> jComboBox) {
        Vector<String> result = new Vector<String>();
        int size = jComboBox.getItemCount();
        for (int i = 0; i < size; ++i) {
            result.add("" + jComboBox.getItemAt(i));
        }
        int index = jComboBox.getSelectedIndex();
        if (index < 0) {
            result.insertElementAt((String)jComboBox.getSelectedItem(), 0);
        } else {
            result.insertElementAt((String)result.remove(index), 0);
        }
        Config.setList(key, result);
    }

    public static final void loadLocation(String key, Component component, Point defaultLocation) {
        try {
            Object[] location = coordonateFormat.parse(Config.getString(key + locationPostfix), new ParsePosition(0));
            component.setLocation(((Number)location[0]).intValue(), ((Number)location[1]).intValue());
        }
        catch (Exception e) {
            component.setLocation(defaultLocation);
        }
    }

    public static final void saveLocation(String key, Component component) {
        Point location = component.getLocation();
        Config.setString(key + locationPostfix, coordonateFormat.format(new Object[]{location.x, location.y}, new StringBuffer(), (FieldPosition)null).toString());
    }

    static {
        configurationModified = false;
        Config.setPWD(Util.class);
        Config.setDataPath(".:..");
        indexFormat = new DecimalFormat("-0000");
        coordonateFormat = new MessageFormat("[x={0,number,integer},y={1,number,integer}]");
    }
}

