/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.MapObjectImpl;
import org.openstreetmap.gui.jmapviewer.Style;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;

public class MapMarkerCircle
extends MapObjectImpl
implements MapMarker {
    Coordinate coord;
    double radius;
    MapMarker.STYLE markerStyle;

    public MapMarkerCircle(Coordinate coord, double radius) {
        this(null, null, coord, radius);
    }

    public MapMarkerCircle(String name, Coordinate coord, double radius) {
        this(null, name, coord, radius);
    }

    public MapMarkerCircle(Layer layer, Coordinate coord, double radius) {
        this(layer, null, coord, radius);
    }

    public MapMarkerCircle(double lat, double lon, double radius) {
        this(null, null, new Coordinate(lat, lon), radius);
    }

    public MapMarkerCircle(Layer layer, double lat, double lon, double radius) {
        this(layer, null, new Coordinate(lat, lon), radius);
    }

    public MapMarkerCircle(Layer layer, String name, Coordinate coord, double radius) {
        this(layer, name, coord, radius, MapMarker.STYLE.VARIABLE, MapMarkerCircle.getDefaultStyle());
    }

    public MapMarkerCircle(Layer layer, String name, Coordinate coord, double radius, MapMarker.STYLE markerStyle, Style style) {
        super(layer, name, style);
        this.markerStyle = markerStyle;
        this.coord = coord;
        this.radius = radius;
    }

    @Override
    public Coordinate getCoordinate() {
        return this.coord;
    }

    @Override
    public double getLat() {
        return this.coord.getLat();
    }

    @Override
    public double getLon() {
        return this.coord.getLon();
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public MapMarker.STYLE getMarkerStyle() {
        return this.markerStyle;
    }

    @Override
    public void paint(Graphics g, Point position, int radio) {
        int size_h = radio;
        int size = size_h * 2;
        if (g instanceof Graphics2D && this.getBackColor() != null) {
            Graphics2D g2 = (Graphics2D)g;
            Composite oldComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3));
            g2.setPaint(this.getBackColor());
            g.fillOval(position.x - size_h, position.y - size_h, size, size);
            g2.setComposite(oldComposite);
        }
        g.setColor(this.getColor());
        g.drawOval(position.x - size_h, position.y - size_h, size, size);
        if (this.getLayer() == null || this.getLayer().isVisibleTexts().booleanValue()) {
            this.paintText(g, position);
        }
    }

    public static Style getDefaultStyle() {
        return new Style(Color.ORANGE, new Color(200, 200, 200, 200), null, MapMarkerCircle.getDefaultFont());
    }

    public String toString() {
        return "MapMarker at " + this.getLat() + " " + this.getLon();
    }

    @Override
    public void setLat(double lat) {
        if (this.coord == null) {
            this.coord = new Coordinate(lat, 0.0);
        } else {
            this.coord.setLat(lat);
        }
    }

    @Override
    public void setLon(double lon) {
        if (this.coord == null) {
            this.coord = new Coordinate(0.0, lon);
        } else {
            this.coord.setLon(lon);
        }
    }
}

