/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;

public abstract class AbstractTMSTileSource
extends AbstractTileSource {
    protected String name;
    protected String baseUrl;
    protected String id;
    private Map<String, String> noTileHeaders;
    private Map<String, String> metadataHeaders;
    protected int tileSize;
    protected OsmMercator osmMercator;

    public AbstractTMSTileSource(TileSourceInfo info) {
        this.name = info.getName();
        this.baseUrl = info.getUrl();
        if (this.baseUrl != null && this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
        this.id = info.getUrl();
        this.noTileHeaders = info.getNoTileHeaders();
        this.metadataHeaders = info.getMetadataHeaders();
        this.tileSize = info.getTileSize();
        this.osmMercator = new OsmMercator(this.tileSize);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getMaxZoom() {
        return 21;
    }

    @Override
    public int getMinZoom() {
        return 0;
    }

    public String getExtension() {
        return "png";
    }

    public String getTilePath(int zoom, int tilex, int tiley) throws IOException {
        return "/" + zoom + "/" + tilex + "/" + tiley + "." + this.getExtension();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public String getTileUrl(int zoom, int tilex, int tiley) throws IOException {
        return this.getBaseUrl() + this.getTilePath(zoom, tilex, tiley);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getTileType() {
        return "png";
    }

    @Override
    public int getTileSize() {
        return this.tileSize;
    }

    @Override
    public double getDistance(double lat1, double lon1, double lat2, double lon2) {
        return this.osmMercator.getDistance(lat1, lon1, lat2, lon2);
    }

    @Override
    public int LonToX(double lon, int zoom) {
        return (int)this.osmMercator.LonToX(lon, zoom);
    }

    @Override
    public int LatToY(double lat, int zoom) {
        return (int)this.osmMercator.LatToY(lat, zoom);
    }

    @Override
    public double XToLon(int x, int zoom) {
        return this.osmMercator.XToLon(x, zoom);
    }

    @Override
    public double YToLat(int y, int zoom) {
        return this.osmMercator.YToLat(y, zoom);
    }

    @Override
    public double latToTileY(double lat, int zoom) {
        return this.osmMercator.LatToY(lat, zoom) / (double)this.tileSize;
    }

    @Override
    public double lonToTileX(double lon, int zoom) {
        return this.osmMercator.LonToX(lon, zoom) / (double)this.tileSize;
    }

    @Override
    public double tileYToLat(int y, int zoom) {
        return this.osmMercator.YToLat(y * this.tileSize, zoom);
    }

    @Override
    public double tileXToLon(int x, int zoom) {
        return this.osmMercator.XToLon(x * this.tileSize, zoom);
    }

    @Override
    public boolean isNoTileAtZoom(Map<String, List<String>> headers, int statusCode, byte[] content) {
        if (this.noTileHeaders != null && headers != null) {
            for (Map.Entry<String, String> searchEntry : this.noTileHeaders.entrySet()) {
                List<String> headerVals = headers.get(searchEntry.getKey());
                if (headerVals == null) continue;
                for (String headerValue : headerVals) {
                    if (!headerValue.matches(searchEntry.getValue())) continue;
                    return true;
                }
            }
        }
        return super.isNoTileAtZoom(headers, statusCode, content);
    }

    @Override
    public Map<String, String> getMetadata(Map<String, List<String>> headers) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (this.metadataHeaders != null && headers != null) {
            for (Map.Entry<String, String> searchEntry : this.metadataHeaders.entrySet()) {
                List<String> headerVals = headers.get(searchEntry.getKey());
                if (headerVals == null) continue;
                for (String headerValue : headerVals) {
                    ret.put(searchEntry.getValue(), headerValue);
                }
            }
        }
        return ret;
    }
}

