/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.util.Map;
import org.openstreetmap.gui.jmapviewer.OsmMercator;

public class TileSourceInfo {
    protected String id;
    protected String url = null;
    protected String name;
    protected Map<String, String> noTileHeaders;
    protected int minZoom;
    protected int maxZoom;
    protected String cookies;
    private int tileSize = OsmMercator.DEFAUL_TILE_SIZE;
    protected Map<String, String> metadataHeaders;

    public TileSourceInfo(String name, String base_url, String id) {
        this(name);
        this.url = base_url;
        this.id = id;
    }

    public TileSourceInfo(String name) {
        this.name = name;
    }

    public TileSourceInfo() {
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getNoTileHeaders() {
        return this.noTileHeaders;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public String getCookies() {
        return this.cookies;
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(int tileSize) {
        if (tileSize <= 0) {
            throw new AssertionError((Object)("Invalid tile size: " + tileSize));
        }
        this.tileSize = tileSize;
    }

    public Map<String, String> getMetadataHeaders() {
        return this.metadataHeaders;
    }
}

