/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import misc.Bundle;
import misc.CommandLineWaiter;
import misc.Log;
import misc.Util;

public class CommandLineServer<Model> {
    private Model model;
    private Class<? extends CommandLineWaiter<Model>> classWaiter;
    private String classWaiterName;
    private TreeSet<String> commands = new TreeSet();
    private Hashtable<String, String> help = new Hashtable();
    private Hashtable<String, Method> actionsMethod = new Hashtable();
    private Thread thread;
    private int lastPort;
    Vector<Socket> calls = new Vector();

    public TreeSet<String> getCommands() {
        return this.commands;
    }

    public Hashtable<String, String> getHelp() {
        return this.help;
    }

    public Hashtable<String, Method> getActionsMethod() {
        return this.actionsMethod;
    }

    public String getClassWaiterName() {
        return this.classWaiterName;
    }

    public void showMsg(String msg) {
    }

    public void showStatus(String msg) {
    }

    public CommandLineServer(Model model, Class<? extends CommandLineWaiter<Model>> classWaiter, Collection<String> commands) {
        this.model = model;
        this.classWaiter = classWaiter;
        String[] path = classWaiter.getName().split("\\.");
        this.classWaiterName = path[path.length - 1];
        for (String action : commands) {
            this.commands.add(action.toLowerCase());
        }
        for (String action : this.commands) {
            try {
                String methodName = "action" + Util.toCapital(action);
                this.actionsMethod.put(action, classWaiter.getMethod(methodName, new Class[0]));
            }
            catch (NoSuchMethodException e) {
                Log.keepLastException("CommandLineServer", e);
            }
        }
        this.updateBundle();
        Bundle.addBundleObserver(this);
    }

    public void updateBundle() {
        this.help.clear();
        for (String cmd : this.commands) {
            this.help.put(cmd, Bundle.getString("Help" + this.classWaiterName + "_" + cmd, null).replaceAll("\\\\n", "\n"));
        }
    }

    public boolean isAliveServer() {
        return this.thread != null && this.thread.isAlive();
    }

    public void stopServer() {
        this.thread = null;
        try {
            new Socket("localhost", this.lastPort).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stopCalls();
    }

    public synchronized void addCall(Socket call) {
        this.calls.add(call);
    }

    public synchronized void removeCall(Socket call) {
        this.calls.remove(call);
    }

    public synchronized void stopCalls() {
        for (Socket call : this.calls) {
            try {
                call.close();
            }
            catch (Exception exception) {}
        }
        this.calls.clear();
    }

    public void startServer(final int port) {
        new Thread(){

            @Override
            public void run() {
                ServerSocket serverSocket = null;
                try {
                    serverSocket = new ServerSocket(port);
                    CommandLineServer.this.lastPort = port;
                }
                catch (IOException e) {
                    CommandLineServer.this.showMsg(Bundle.getMessage("CanTCreateSocket"));
                    Log.keepLastException("CommandLineServer::startServer", e);
                    return;
                }
                CommandLineServer.this.showMsg(MessageFormat.format(Bundle.getMessage(CommandLineServer.this.classWaiterName + "Starts"), port));
                CommandLineServer.this.showStatus(MessageFormat.format(Bundle.getMessage(CommandLineServer.this.classWaiterName + "Starts"), port));
                CommandLineServer.this.thread = Thread.currentThread();
                try {
                    while (CommandLineServer.this.thread == Thread.currentThread()) {
                        try {
                            Socket call = serverSocket.accept();
                            CommandLineServer.this.addCall(call);
                            CommandLineServer.this.classWaiter.getConstructor(CommandLineServer.class, CommandLineServer.this.model.getClass(), Socket.class).newInstance(CommandLineServer.this, CommandLineServer.this.model, call);
                        }
                        catch (IOException e) {
                            CommandLineServer.this.showMsg(Bundle.getMessage("ClientAbort"));
                            Log.keepLastException("CommandLineServer::startServer", e);
                        }
                    }
                }
                catch (InvocationTargetException e) {
                    Log.keepLastException("CommandLineServer::startServer", e);
                }
                catch (NoSuchMethodException e) {
                    Log.keepLastException("CommandLineServer::startServer", e);
                }
                catch (IllegalAccessException e) {
                    Log.keepLastException("CommandLineServer::startServer", e);
                }
                catch (InstantiationException e) {
                    Log.keepLastException("CommandLineServer::startServer", e);
                }
                try {
                    CommandLineServer.this.showMsg(Bundle.getMessage(CommandLineServer.this.classWaiterName + "Stopped"));
                    CommandLineServer.this.showStatus(Bundle.getMessage(CommandLineServer.this.classWaiterName + "Stopped"));
                    serverSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
    }
}

