/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

public class ImagePreview
extends JComponent
implements PropertyChangeListener {
    public static int maxInSide = 90;
    public static int border = 5;
    public static int maxOutSide = maxInSide + 2 * border;
    protected ImageIcon thumbnail = null;
    protected File file = null;
    protected long maxSize;

    public ImagePreview(JFileChooser fc, long maxSize) {
        this.maxSize = maxSize;
        this.setPreferredSize(new Dimension(maxOutSide, maxOutSide));
        fc.addPropertyChangeListener(this);
    }

    public void loadImage() {
        if (this.file == null || this.maxSize > 0L && this.file.length() > this.maxSize) {
            this.thumbnail = null;
            return;
        }
        ImageIcon tmpIcon = new ImageIcon(this.file.getPath());
        if (tmpIcon != null) {
            this.thumbnail = tmpIcon;
            if (tmpIcon.getIconWidth() > tmpIcon.getIconHeight()) {
                if (tmpIcon.getIconWidth() > maxInSide) {
                    this.thumbnail = new ImageIcon(tmpIcon.getImage().getScaledInstance(maxInSide, -1, 1));
                }
            } else if (tmpIcon.getIconHeight() > maxInSide) {
                this.thumbnail = new ImageIcon(tmpIcon.getImage().getScaledInstance(-1, maxInSide, 1));
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.file = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.file = (File)e.getNewValue();
            update = true;
        }
        if (update) {
            this.thumbnail = null;
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            if (y < border) {
                y = border;
            }
            if (x < border) {
                x = border;
            }
            this.thumbnail.paintIcon(this, g, x, y);
        }
    }
}

