/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableModel;
import misc.Bundle;
import misc.Config;
import misc.OwnFrame;
import misc.ProgressState;
import misc.ProgressStatePanel;
import misc.RemoteUpdate;
import misc.StateNotifier;
import misc.Util;

public class JRemoteUpdate
implements SwingConstants {
    public static String actionDetails = "Details";
    public static String labelFileName = "FileName";
    public static String labelLocal = "Local";
    public static String labelRemote = "Remote";
    private OwnFrame controller;
    RemoteUpdate remoteUpdate;
    Runnable actionAfterDownLoad;
    JPanel jPanel = Util.getGridBagPanel();
    ArrayList<MirrorInfo> allMirrorInfo;
    JFrame jFrame = new JFrame();
    JButton startAction;
    private int nbThreads;
    private boolean isDownload;

    public JRemoteUpdate(OwnFrame controller, RemoteUpdate remoteUpdate, Runnable actionAfterDownLoad) {
        this.controller = controller;
        this.remoteUpdate = remoteUpdate;
        this.actionAfterDownLoad = actionAfterDownLoad;
        this.jFrame.setIconImage(controller.getIcon());
    }

    private synchronized void resetThreads(int nbThreads, boolean isDownload) {
        if (nbThreads < 1) {
            return;
        }
        while (this.nbThreads != 0) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        this.isDownload = isDownload;
        this.startAction.setEnabled(false);
        this.nbThreads = nbThreads;
    }

    private synchronized void decrThreads() {
        --this.nbThreads;
        if (this.nbThreads != 0) {
            return;
        }
        this.notifyAll();
        this.startAction.setEnabled(true);
        if (this.isDownload && this.actionAfterDownLoad != null) {
            this.actionAfterDownLoad.run();
        }
    }

    public void dialog(final RemoteUpdate.TodoFile action, boolean checkPeriod) {
        this.jPanel.removeAll();
        this.allMirrorInfo = new ArrayList();
        for (RemoteUpdate.Mirror mirror : this.remoteUpdate.mirrors) {
            this.allMirrorInfo.add(new MirrorInfo(mirror, action));
        }
        for (MirrorInfo mirrorInfo : this.allMirrorInfo) {
            mirrorInfo.update();
        }
        this.startAction = Util.addButton("" + (Object)((Object)action), null, this.jPanel, Util.GBCNL);
        this.startAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    @Override
                    public void run() {
                        JRemoteUpdate.this.resetThreads(JRemoteUpdate.this.allMirrorInfo.size(), action == RemoteUpdate.TodoFile.Download);
                        for (MirrorInfo mirrorInfo : JRemoteUpdate.this.allMirrorInfo) {
                            mirrorInfo.startAction();
                        }
                    }
                }.start();
            }
        });
        if (checkPeriod) {
            JPanel line = Util.getGridBagPanel();
            Util.addLabel("CheckingPeriod", 2, line, Util.GBC);
            JComboBox<String> periodChooser = Util.addEnum(RemoteUpdate.CheckPeriod.class, this.remoteUpdate.currentPeriod(), line, Util.GBCNL);
            Util.addComponent(line, this.jPanel, Util.GBCNL);
            if (JOptionPane.showConfirmDialog(this.jFrame, this.jPanel, Bundle.getTitle("" + (Object)((Object)action)), 0, 3) == 0) {
                Config.setString("CheckPeriod", "" + (Object)((Object)RemoteUpdate.CheckPeriod.values()[periodChooser.getSelectedIndex()]));
            }
        } else {
            JOptionPane.showMessageDialog(this.jFrame, this.jPanel, Bundle.getTitle("" + (Object)((Object)action)), 3);
        }
        for (MirrorInfo mirrorInfo : this.allMirrorInfo) {
            mirrorInfo.progressState.abort();
        }
        for (MirrorInfo mirrorInfo : this.allMirrorInfo) {
            mirrorInfo.setConfig();
        }
    }

    public void downloadDialog() {
        this.dialog(RemoteUpdate.TodoFile.Download, true);
    }

    public void uploadDialog() {
        this.dialog(RemoteUpdate.TodoFile.Upload, false);
    }

    public class MirrorInfo {
        RemoteUpdate.Mirror mirror;
        StateNotifier notifier = new StateNotifier();
        public ProgressState progressState = new ProgressState(this.notifier, "Progress");
        RemoteUpdate.TodoFile transfertAction;
        RemoteUpdate.TodoFile cleanAction;
        JCheckBox transfertBoutton;
        JCheckBox cleanBoutton;
        JLabel info;
        ProgressStatePanel progressStatePanel = new ProgressStatePanel(this.progressState);

        MirrorInfo(RemoteUpdate.Mirror mirror, RemoteUpdate.TodoFile transfertAction) {
            this.mirror = mirror;
            this.transfertAction = transfertAction;
            this.cleanAction = transfertAction == RemoteUpdate.TodoFile.Download ? RemoteUpdate.TodoFile.LocalRemove : RemoteUpdate.TodoFile.RemoteRemove;
            this.transfertBoutton = Util.addCheckIcon("" + (Object)((Object)transfertAction), null, Config.getBoolean((Object)((Object)transfertAction) + mirror.token + "Checked", false), JRemoteUpdate.this.jPanel, Util.GBC);
            this.cleanBoutton = Util.addCheckIcon("" + (Object)((Object)this.cleanAction), null, Config.getBoolean((Object)((Object)this.cleanAction) + mirror.token + "Checked", false), JRemoteUpdate.this.jPanel, Util.GBC);
            this.notifier.addUpdateObserver(this.progressStatePanel, "Progress");
            this.info = new JLabel(mirror.getInfo(mirror.check(transfertAction), transfertAction));
            Util.addComponent(this.info, JRemoteUpdate.this.jPanel, Util.GBC);
            Util.addIconButton(actionDetails, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(JRemoteUpdate.this.jFrame, MirrorInfo.this.getDetails(), Bundle.getTitle("" + actionDetails), 1);
                }
            }, (Container)JRemoteUpdate.this.jPanel);
            Util.unBoxButton(JRemoteUpdate.this.jPanel);
            Util.addComponent(this.progressStatePanel, JRemoteUpdate.this.jPanel, Util.GBCNL);
        }

        public void setConfig() {
            Config.setBoolean((Object)((Object)this.transfertAction) + this.mirror.token + "Checked", this.transfertBoutton.isSelected());
            Config.setBoolean((Object)((Object)this.cleanAction) + this.mirror.token + "Checked", this.cleanBoutton.isSelected());
        }

        public void update() {
            new Thread(){

                @Override
                public void run() {
                    MirrorInfo.this.mirror.update();
                    MirrorInfo.this.info.setText(MirrorInfo.this.mirror.getInfo(MirrorInfo.this.mirror.check(MirrorInfo.this.transfertAction), MirrorInfo.this.transfertAction));
                }
            }.start();
        }

        public JScrollPane getDetails() {
            DefaultTableModel dataObjectModel = new DefaultTableModel(){

                @Override
                public Class<?> getColumnClass(int column) {
                    if (column != 1) {
                        return String.class;
                    }
                    return ImageIcon.class;
                }
            };
            JTable jTableObject = new JTable(dataObjectModel);
            jTableObject.getTableHeader().setReorderingAllowed(true);
            jTableObject.setShowVerticalLines(false);
            JScrollPane scrollPane = Util.getJScrollPane(jTableObject, true, false);
            jTableObject.setFillsViewportHeight(true);
            dataObjectModel.setColumnCount(6);
            Util.setColumnLabels(jTableObject, new String[]{"FileName", null, "LocalDate", "LocalSize", "RemoteDate", "RemoteSize"});
            for (RemoteUpdate.TodoFile action : new RemoteUpdate.TodoFile[]{this.transfertAction, this.cleanAction}) {
                for (String fileName : this.mirror.check(action)) {
                    RemoteUpdate.FileDescriptor fd = this.mirror.getInfo(fileName);
                    RemoteUpdate.FileInfo lfi = fd.local;
                    RemoteUpdate.FileInfo rfi = fd.remote;
                    dataObjectModel.addRow(new Object[]{fileName, Util.loadActionIcon("" + (Object)((Object)fd.todo) + "On"), RemoteUpdate.FileInfo.getDate(lfi), RemoteUpdate.FileInfo.getSize(lfi), RemoteUpdate.FileInfo.getDate(rfi), RemoteUpdate.FileInfo.getSize(rfi)});
                }
            }
            scrollPane.setPreferredSize(new Dimension(800, 400));
            return scrollPane;
        }

        public void startAction() {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        String messagePrefix;
                        String string = messagePrefix = MirrorInfo.this.transfertAction == RemoteUpdate.TodoFile.Download ? "Download" : "Upload";
                        if (!MirrorInfo.this.cleanBoutton.isSelected() && !MirrorInfo.this.transfertBoutton.isSelected()) {
                            return;
                        }
                        MirrorInfo.this.mirror.update();
                        TreeSet<Object> removed = new TreeSet();
                        if (MirrorInfo.this.cleanBoutton.isSelected()) {
                            removed = MirrorInfo.this.mirror.performe(MirrorInfo.this.cleanAction, null);
                        }
                        TreeSet<Object> transfered = new TreeSet();
                        if (MirrorInfo.this.transfertBoutton.isSelected()) {
                            transfered = MirrorInfo.this.mirror.performe(MirrorInfo.this.transfertAction, MirrorInfo.this.progressState);
                            MirrorInfo.this.mirror.update();
                            MirrorInfo.this.info.setText(MirrorInfo.this.mirror.getInfo(MirrorInfo.this.mirror.check(MirrorInfo.this.transfertAction), MirrorInfo.this.transfertAction));
                        }
                        if (removed.size() == 0 && transfered.size() == 0) {
                            return;
                        }
                        JPanel msgPanel = Util.getGridBagPanel();
                        Util.addComponent(new JLabel(MessageFormat.format(Bundle.getMessage(messagePrefix + "Completed"), transfered.size())), msgPanel, Util.GBCNL);
                        if (transfered.size() > 0) {
                            Util.addLabel("" + (Object)((Object)MirrorInfo.this.transfertAction), 2, msgPanel, Util.GBCNL);
                            Util.addComponent(Util.getJScrollPane(new JList<Object>(new Vector<Object>(transfered))), msgPanel, Util.GBCNL);
                        }
                        if (removed.size() > 0) {
                            Util.addLabel("Remove", 2, msgPanel, Util.GBCNL);
                            Util.addComponent(Util.getJScrollPane(new JList<Object>(new Vector<Object>(removed))), msgPanel, Util.GBCNL);
                        }
                        JOptionPane.showMessageDialog(JRemoteUpdate.this.jFrame, msgPanel, Bundle.getTitle("" + (Object)((Object)MirrorInfo.this.transfertAction)), 1);
                    }
                    finally {
                        JRemoteUpdate.this.decrThreads();
                    }
                }
            }.start();
        }
    }
}

