/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.util.HashSet;
import misc.StateNotifier;

public class ProgressState {
    HashSet<Thread> workingThreads = new HashSet();
    StateNotifier observable;
    String valueName;
    public State state;
    public String domain;
    public int value;
    public int maxValue;

    public ProgressState(StateNotifier observable, String valueName) {
        this.observable = observable;
        this.valueName = valueName;
    }

    public synchronized void init(String domain, int maxValue) {
        this.domain = domain;
        this.value = 0;
        this.maxValue = maxValue;
        this.state = State.Init;
        this.workingThreads = new HashSet();
        this.workingThreads.add(Thread.currentThread());
        this.observable.broadcastUpdate(this.valueName);
    }

    public synchronized void addThread(Thread thread) {
        this.workingThreads.add(thread);
    }

    public synchronized void abort() {
        this.workingThreads.clear();
    }

    public synchronized boolean isInterrupted() {
        return !this.workingThreads.contains(Thread.currentThread());
    }

    public synchronized boolean setValue(int value) {
        this.value = value;
        this.state = State.Value;
        this.observable.broadcastUpdate(this.valueName);
        return this.workingThreads.contains(Thread.currentThread());
    }

    public synchronized boolean addValue(int delta) {
        if (delta > 0) {
            this.value += delta;
            this.state = State.Value;
            this.observable.broadcastUpdate(this.valueName);
        }
        return this.workingThreads.contains(Thread.currentThread());
    }

    public synchronized void end() {
        this.state = State.End;
        this.observable.broadcastUpdate(this.valueName);
    }

    public static enum State {
        Init,
        Value,
        End;

    }
}

