/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import misc.Util;

public class SpinnerSlider
extends JPanel
implements ChangeListener {
    public static int MaxPrecision = 10000;
    public static NumberFormat numberFormat = NumberFormat.getInstance(Locale.FRENCH);
    Accessor accessor;
    public double minValue;
    public double maxValue;
    public SpinnerNumberModel snm = new SpinnerNumberModel(0.0, 0.0, 0.0, 1.0){

        @Override
        public Object getPreviousValue() {
            Number value = (Number)super.getPreviousValue();
            return SpinnerSlider.this.getPreviousValue(value);
        }

        @Override
        public Object getNextValue() {
            Number value = (Number)super.getNextValue();
            return SpinnerSlider.this.getNextValue(value);
        }
    };
    public JSpinner spinner = new JSpinner(this.snm);
    public JLabel label = new JLabel("/0");
    private JSlider slider = new JSlider(0, MaxPrecision, 1);

    public SpinnerSlider(Accessor accessor, int textLength, float slideWidthCoef) {
        super(null);
        this.accessor = accessor;
        this.snm.addChangeListener(this);
        this.slider.addChangeListener(this);
        ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().setColumns(textLength);
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)this.spinner.getEditor();
        DecimalFormat format = editor.getFormat();
        format.setDecimalSeparatorAlwaysShown(true);
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(12);
        this.setLayout(new GridBagLayout());
        Util.addComponent(this.spinner, this, Util.GBC);
        Util.addComponent(this.label, this, Util.GBC);
        Util.addComponent(this.slider, this, Util.GBCNL);
        Dimension d = this.slider.getPreferredSize();
        d.width = (int)(slideWidthCoef * (float)d.width);
        this.slider.setPreferredSize(d);
        this.slider.setMinimumSize(d);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            if (e.getSource() == this.slider) {
                this.accessor.set((double)this.slider.getValue() / (double)MaxPrecision * (this.maxValue - this.minValue) + this.minValue);
            } else if (e.getSource() == this.snm) {
                this.accessor.set(((Number)this.snm.getValue()).doubleValue());
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void update() {
        double[] doubleValues = this.accessor.get();
        this.minValue = doubleValues[0];
        this.maxValue = doubleValues[1];
        this.slider.removeChangeListener(this);
        this.snm.removeChangeListener(this);
        this.snm.setMinimum(Double.valueOf(doubleValues[0]));
        this.snm.setMaximum(Double.valueOf(doubleValues[1]));
        this.snm.setValue(doubleValues[2]);
        this.slider.setValue((int)((doubleValues[2] - this.minValue) / (this.maxValue - this.minValue) * (double)MaxPrecision));
        this.label.setText("/" + numberFormat.format((float)doubleValues[1]));
        this.snm.addChangeListener(this);
        this.slider.addChangeListener(this);
    }

    public Number getPreviousValue(Number value) {
        return value;
    }

    public Number getNextValue(Number value) {
        return value;
    }

    static {
        numberFormat.setGroupingUsed(true);
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setMaximumFractionDigits(12);
    }

    public static interface Accessor {
        public void set(double var1);

        public double[] get();
    }
}

